﻿import Table from '@mui/material/Table';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import Paper from '@mui/material/Paper';
import { PitcherStats } from '../types';
import { teamsMap } from '../teamsMap';

export default function PitcherStatsTable(rows: { rows: PitcherStats[] }) {
    return (
        <TableContainer component={Paper}>
            <Table aria-label="Pitcher Statistics Table">
                <TableHead>
                    <TableRow>
                        <TableCell><b>Year</b></TableCell>
                        <TableCell><b>Team</b></TableCell>
                        <TableCell><b>Games</b></TableCell>
                        <TableCell><b>Games Started</b></TableCell>
                        <TableCell><b>Wins-Losses-Saves</b></TableCell>
                        <TableCell><b>Innings Pitched</b></TableCell>
                        <TableCell><b>Hits</b></TableCell>
                        <TableCell><b>Strike Outs</b></TableCell>
                        <TableCell><b>Walks</b></TableCell>
                        <TableCell><b>ERA</b></TableCell>
                    </TableRow>
                </TableHead>
                <TableBody>
                    {rows?.rows?.map((row: PitcherStats, index: number) => {
                        return (
                            <TableRow
                                key={index}
                                sx={{ '&:last-child td, &:last-child th': { border: 0 } }}
                            >
                                <TableCell>{row.yearid}</TableCell>
                                <TableCell>{teamsMap[row.teamid]}</TableCell>
                                <TableCell>{row.g}</TableCell>
                                <TableCell>{row.gs}</TableCell>
                                <TableCell>{row.w}-{row.l}-{row.sv}</TableCell>
                                <TableCell>{((row.outs / 3) + (row.outs % 3) / 10.0).toFixed(2)}</TableCell>
                                <TableCell>{row.b1 + row.b2 + row.b3 + row.hr}</TableCell>
                                <TableCell>{row.so}</TableCell>
                                <TableCell>{row.ibb + row.ubb}</TableCell>
                                <TableCell>{((row.er * 27.0) / row.outs).toFixed(2)}</TableCell>
                            </TableRow>
                        )
                    })}
                </TableBody>
            </Table>
        </TableContainer>
    );
}